! This code extracts merged the observed data along flight tracks and extracts
! the corresponding model data
! Code created by Youhua Tang and Chao Wei
! Modified by Sarika Kulkarni on 31 Jan 2012
!------------------------------------------------------------------------------------------
      program conv_group
      include 'PARMS3.EXT'      ! i/o API
      include 'FDESC3.EXT'      ! i/o API
      include 'IODECL3.EXT'     ! i/o API      
!------------------------------------------------------------------------------------------
! wind direction rotation from Polar stereographic projection to geographical coordinate
!------------------------------------------------------------------------------------------
      real cone,alpha,v_g,u_g,diff
!------------------------------------------------------------------------------------------
       integer, parameter :: imax = 249 ! No. of lon
       integer, parameter :: jmax = 249 ! No. of lat
       integer, parameter :: kmmax = 22 ! No. of lat
       integer, parameter :: kmax = 22! No. of lat
       integer, parameter :: ioff = 0 ! No. of lat
       integer, parameter :: joff = 0 ! No. of lat
       integer, parameter :: itrace = 249 ! No. of lat
       integer, parameter :: jtrace = 249 ! No. of lat
!---------------------------------------------------------------------------------------!------------------------------------------------------------------------------------------
      real	!!!!!!!!! Tmp array
     &conlevs(kmmax), 	!!!!!!!!!Conversion levels
     &conzhlevs(kmmax), 	!!!!!!!!!Conversion levels
     &contemplevs(kmmax), 	!!!!!!!!!Conversion levels
     &conpresslevs(kmmax), 	!!!!!!!!!Conversion levels
     &conulevs(kmmax), 	!!!!!!!!!Conversion levels
     &convlevs(kmmax), 	!!!!!!!!!Conversion levels
     &convaplevs(kmmax), 	!!!!!!!!!Conversion levels
     &conso2levs(kmmax), 	!!!!!!!!!Conversion levels
     &conpso4levs(kmmax), 	!!!!!!!!!Conversion levels
     &conwslevs(kmmax), 	!!!!!!!!!Conversion levels
     &conwdlevs(kmmax), 	!!!!!!!!!Conversion levels
     &conrhlevs(kmmax), 	!!!!!!!!!Conversion levels
     &work2d(imax,jmax),	!!!!!!!!! Tmp array
     &topo(imax,jmax),	!!!!!!!!!Topography
     &xlon(imax,jmax), 	!!!!!!!!!Model grid lon
     &xlat(imax,jmax), 	!!!!!!!!!Model grid lat
     &trtopo(itrace,jtrace),	!!!!!!!!! Tracer topography height
     &work(imax,jmax,kmmax), 	!!!!!!!!!Conversion levels
     &zheight(imax,jmax,kmmax),	!!!!!!!!! model layer height
     &trheight(itrace,jtrace,kmmax),	!!!!!!!!! Tracer model layer height
     &trtemp(itrace,jtrace,kmmax),	!!!!!!!!! Tracer model layer height
     &trpress(itrace,jtrace,kmmax),	!!!!!!!!! Tracer model layer height
     &work2(imax,jmax,kmmax) 		!!!!!!!!! Tmp array 2 
!     &work2d(imax,jmax,kmmax),
!     &work2(imax,jmax,kmmax),   
!------------------------------------------------------------------------------------------
      character afile(20)*200,
     &aline*15000,
     &aline2*400,
     &prefix(2)*200,
     &suffix(2)*80,
     &afile2(20)*200,
     &outnc(20)*200,
     &tmpnc(20)*200,
     &outctl(20)*200,
     &chtmp*2,
     &afile3(20)*200,
     &pcdata(400)*80
!------------------------------------------------------------------------------------------
      integer jday,jtime,nulldate,nulltime,missions(1),julianday(1),
     & btime,samstep,loop,startjday,startime,loop2,tmpL,mth,dy                            ! sampling step in second
!------------------------------------------------------------------------------------------
!      integer jday,jtime,nulldate,nulltime,missions(20),julianday(20),
!------------------------------------------------------------------------------------------
      real pdata(400),amass(5),convratio(400)
      logical first,interp4
!------------------------------------------------------------------------------------------
       integer :: num2dncfiles,nvars_2d
       integer :: num3dncfiles,nvars_3d
       integer :: numts
      namelist /control/missions,julianday,  ! mission numbers
     &  prefix,suffix,num2dncfiles,num3dncfiles,numts 
!------------------------------------------------------------------------------------------
      parameter(num_noz=3)
      integer l_noz(num_noz)
!------------------------------------------------------------------------------------------
       namelist /obs_index/l_julian,l_gmt,l_lon,l_lat,l_alt,l_press,
     & l_temp,l_rh,l_so4,l_no,l_no2,l_bc,l_so2,l_amsso4
!---------------------------------------------------------------------------------------!------------------------------------------------------------------------------------------
      real c303,c302
      parameter(C303=19.83,C302=5417.4)
!------------------------------------------------------------------------------------------
      real lat1,lon1,knowni,knownj
      real truelat1, truelat2, stdlon, ddx, cenlat, cenlon
!------------------------------------------------------------------------------------------
        !integer, parameter :: mxvarnum=2000
        CHARACTER*16    monchar( 12 )
	data monchar/ 
     &'JAN','FEB','MAR','APR',
     &'MAY','JUN','JUL','AUG',
     &'SEP','OCT','NOV','DEC'/
!---------------------------------------------------------------------------------------
        integer, parameter :: mxvarnum=2000
        CHARACTER*16    VNAME_2D( mxvarnum )
        CHARACTER*16    UNITS_2D( mxvarnum )
        CHARACTER*16    VFILE_2D( mxvarnum )
        CHARACTER*16    INFILE2D

        CHARACTER*16    VNAME_3D( mxvarnum )
        CHARACTER*16    UNITS_3D( mxvarnum )
        CHARACTER*16    VFILE_3D( mxvarnum )
        CHARACTER*16    INFILE3D
!---------------------------------------------------------------------------------------
       integer, parameter :: interpzlevs=40
       REAL :: outzlevs(interpzlevs) 
       data outzlevs/ 
     &  50.,
     &  100.,
     &  200.,
     &  300.,
     &  400.,
     &  500.,
     &  650.,
     &  800.,
     &  1000.,
     &  1250.,
     &  1500.,
     &  1750.,
     &  2000.,
     &  2250.,
     &  2500.,
     &  2750.,
     &  3000.,
     &  3250.,
     &  3500.,
     &  3750.,
     &  4000.,
     &  4250.,
     &  4500.,
     &  4750.,
     &  5000.,
     &  5500.,
     &  6000.,
     &  6500.,
     &  7000.,
     &  7500.,
     &  8000.,
     &  8500.,
     &  9000.,
     &  9500.,
     &  10000.,
     &  11000.,
     &  12000.,
     &  13000.,
     &  14000.,
     &  15000./  

      real	!!!!!!!!! Tmp array
     &convoutzlevs(interpzlevs)
!------------------------------------------------------------------------------------------
! --- end WORK_AREAS declarations
!------------------------------------------------------------------------------------------
      ESAT(TEMK)=.611*EXP(C303-C302/TEMK)       ! for calculating saturated water vapor pressure  
      QSAT(ESAT1,PCB)=ESAT1*.622/(PCB-ESAT1)    ! TEMK is ambient temperature in K, PCB is the pressue in KPa
                                                ! QSAT is the saturated humidity in kg/kg      
!------------------------------------------------------------------------------------------
      afconst=6.023e23
      paiv=atan(1.)/45 
      radius=6.37e6      ! radius of earth in meter
      
      knownj=1.00         ! origin point, y-location
      knowni=1.00         ! origin point, x-location

      lat1=14.78607082366943      ! LAT_LL_D  in WRF
      lon1=-86.17755126953125     ! LON_LL_D  in WRF

      truelat1=90.00000	    ! true lat 1 from WRF
      truelat2=90.00000	    ! true lat 2 from WRF

      stdlon=-40.00000                 ! Stand_LON from WRF
      ddx=60000.0000                   ! grid size in meter from WRF
      cenlat=82.99996185302734     ! cen_lat from WRF
      cenlon=110.0                 ! cen_lon from WRF ! in mtopo cenlon is changed to stdlon
!------------------------------------------------------------------------------------------
c      write(*,control)
!------------------------------------------------------------------------------------------
      open(7,file='conv3d_tracer.ini')
      read(7,control)            ! read in filenames 
      read(7,obs_index)          ! read the index of species in the obs data file
      close(7)
!------------------------------------------------------------------------------------------
      ! check namelist
!      print*,"obs_index=",l_julian,l_gmt,l_lon,l_lat,l_alt,l_press,
!     1 l_temp,l_rh,l_so4,l_no,l_no2,l_bc,l_so2,l_amsso4
!------------------------------------------------------------------------------------------
!---------------Open TOPO file and Read Topography height----------------------------------
!------------------------------------------------------------------------------------------
      if(.not.open3('TOPO',FSREAD3,'pathway')) then   
       print*,' Error open TOPO file'
       stop
      endif
!-----------------------------------------------------------------------------------------!--------------------------------------------------------------------------
      if(.not.READ3('TOPO','LAT',ALLAYS3, 0, 0, xlat)) then
        print*, 'Error in reading topograph'
	   stop
      endif      
    !------------------------------------------------------------------
      if(.not.READ3('TOPO','LON',ALLAYS3, 0, 0, xlon)) then
        print*, 'Error in reading topograph'
	   stop
      endif      
    !------------------------------------------------------------------
      if(.not.READ3('TOPO','TOPO',ALLAYS3, 0, 0, trtopo)) then
        print*, 'Error in reading topograph'
	  stop
      endif      
      iflag=close3('TOPO')
!------------------------------------------------------------------------------------------
!---------------Close TOPO file----------------------------------
!------------------------------------------------------------------------------------------
!------------------------------------------------------------------------------------------
 !------------------------------------------------------------------------------------------
!---------------Open/Read WRF layer height file----------------------------------
!------------------------------------------------------------------------------------------
      if(.not.open3('METEO3D',FSREAD3,'stem2v5d')) then   
       print*,' Error open METEO3D file'
       stop
      endif
	!------------------------------------------------------------------------------------------
!------------------------------------------------------------------------------------------
!<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-
       nvars_3d = 0;
       do L = 1,num3dncfiles
        
!----------------------------------------------------------------------
 !----------------------------------------------------------------------
        WRITE(INFILE3D, 200) L
200     FORMAT('INFILE3D'I3.3)
	 print*, TRIM(INFILE3D)
	 !print*, INFILE
         if(.not.OPEN3(INFILE3D,FSREAD3,'pathway')) then
          print*,'Open input file error for ',"'//TRIM(INFILE3D)//'" 
          stop
         endif
!----------------------------------------------------------------------
         if (.not. DESC3(INFILE3D) ) then   ! get grid information from 3d AOE
          print*, 'Error getting info from ', "'//TRIM(INFILE3D)//'"
          stop
         endif
	 print*, TRIM(INFILE3D)
!----------------------------------------------------------------------
       if (L.eq.1)then
         !imax=ncols3d
         !jmax=nrows3d
         !kmax=nlays3d
	 kaero=nlays3d
         record1 = mxrec3d
         print*,imax,jmax,kmax,record1
       endif
!----------------------------------------------------------------------
            DO  I = 1, NVARS3D
              VNAME_3D(nvars_3d+I) = VNAME3D(I)
	      if((index(UNITS3D( I ),'ug/m3')).ne.0)
     &		UNITS3D( I )='ug/Std m3'
                UNITS_3D(nvars_3d+I) = UNITS3D( I )
		VFILE_3D(nvars_3d+I) = INFILE3D
	print*, nvars_3d,VNAME_3D(nvars_3d+I),vname3d(I),INFILE3D
            END DO
       !print*, VNAME3D
        !print*, VNAME_3D(1:NVARS3D)

        nvars_3d = nvars_3d + nvars3d;
       enddo
        print*, VNAME_3D(1:nvars_3d)
!------------------------------------------------------------------------------------------
!Start reading the input flight track data
!------------------------------------------------------------------------------------------
      nfile=0
!      do i=1,20
      do i=1,1
       if(missions(i).gt.0) then
        nfile=nfile+1
        write(chtmp,'(i2.2)')missions(i)
        aline=prefix(1)
	   aline2=suffix(1)
	 afile(i)=aline(:len_trim(aline))//chtmp//
     &	  aline2(:len_trim(aline2))
        aline=prefix(2)
	  aline2=suffix(2)
	 afile2(i)=aline(:len_trim(aline))//chtmp//
     &	  aline2(:len_trim(aline2))
       outnc(i)=trim(prefix(2))//chtmp//'-Curtain.nc'
       outctl(i)=trim(prefix(2))//chtmp//'-Curtain.ctl'
       tmpnc(i)='dc8curtain.nc'
       else
        exit
       endif
      enddo 
      print*,afile(1),afile2(1),nfile
      print*,outnc(1),tmpnc(1),outctl(1)
!------------------------------------------------------------------------------------------
!------------------------------------------------------------------------------------------
      do mn=1,nfile              ! begin pick up files 
!      print*,'open data ',afile(mn),afile2(mn)
      open(7,file=afile(mn))    ! input file
      read(7,'(a15000)')aline
!------------------------------------------------------------------------------------------
      nleng_aline = LEN_TRIM(aline)-1
      if(aline(nleng_aline:nleng_aline).eq.",")
     &  aline=aline(1:nleng_aline-1)
!------------------------------------------------------------------------------------------
      call decommac(trim(aline),pcdata,ndata)
!------------------------------------------------------------------------------------------
!------------------------------------------------------------------------------------------
      convratio(1:400)=1.
c      if(index(pcdata(l_alt),'km').ne.0) then
c       pcdata(l_alt)='"ALP_(m)"'
c       convratio(l_alt)=1000.
c      endif
!------------------------------------------------------------------------------------------
      if(index(pcdata(l_gmt),'UTC (sec)').ne.0) then
       pcdata(l_gmt)='UTC (hr)'
       convratio(l_gmt)=1/3600.         ! convert to hour
      endif 
!------------------------------------------------------------------------------------------
      if(index(pcdata(l_so4),'Fine_Aerosol_Sulfate (pptv)').ne.0) then
       pcdata(l_so4)='Fine_Aerosol_Sulfate (ug/Std m3)'
       convratio(l_so4)=3.9264/1000.                     !  ug/stdm3 = ppbv * MoleWeight * 0.0409
      endif
!------------------------------------------------------------------------------------------
      if(index(pcdata(l_bc),'BC_Mass@1013hpa_273K (ng/m3)').ne.0) then
       pcdata(l_bc)='BC (ug/Std m3)'
       convratio(l_bc)=-3                    !  ug/stdm3 = ppbv * MoleWeight * 0.0409
      endif
!------------------------------------------------------------------------------------------
      if(index(pcdata(l_amsso4),'Sulphate (ug/m3)').ne.0) then
       pcdata(l_amsso4)='Sulphate (ug/Std m3)'
       convratio(l_amsso4)=-4                   !  ug/stdm3 = ppbv * MoleWeight * 0.0409
      endif
!------------------------------------------------------------------------------------------
!        i=index(pcdata(n),'(ng/m3)')  ! UNH aerosol
!	   print*, "Index",i
!        if(i.eq.1) then
!         convratio(n)=-3   ! ng/m3 to ug/std m3 ???
!         pcdata(n)='(ug/std m3)'
!        endif
!------------------------------------------------------------------------------------------

!------------------------------------------------------------------------------------------
!------------------------------------------------------------------------------------------
!<>-<>-<>-<>-<>-<>-<>-Write output file -<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-
!------------------------------------------------------------------------------------------
!------------------------------------------------------------------------------------------
!------------------------------------------------------------------------------------------
      open(8,file=afile2(mn))                ! output files
      write(8,"('julian',$)")
      print*,'obs data number=',ndata
!------------------------------------------------------------------------------------------
      do n=1,ndata
!------------------------------------------------------------------------------------------
        i=index(pcdata(n),'Na- (pptv)')  
        if(i.eq.1.OR.(i.gt.1.AND.pcdata(n)(i-1:i-1).eq." ")) then
         convratio(n)=22.99* 0.0409/1000.      !  ug/stdm3 = ppbv * MoleWeight * 0.0409 (dc8)
         pcdata(n)='Na (ug/std m3)'
        endif
	!------------------------------------------------------------------------------------------
        i=index(pcdata(n),'NH4 (pptv)')  
        if(i.eq.1.OR.(i.gt.1.AND.pcdata(n)(i-1:i-1).eq." ")) then
         convratio(n)=18.05* 0.0409/1000.      !  ug/stdm3 = ppbv * MoleWeight * 0.0409 (dc8)
         pcdata(n)='NH4 (ug/std m3)'
        endif
	!------------------------------------------------------------------------------------------
        i=index(pcdata(n),'K (pptv)')  
        if(i.eq.1.OR.(i.gt.1.AND.pcdata(n)(i-1:i-1).eq." ")) then
         convratio(n)=39.10* 0.0409/1000.      !  ug/stdm3 = ppbv * MoleWeight * 0.0409 (dc8)
         pcdata(n)='K (ug/std m3)'
        endif
	!------------------------------------------------------------------------------------------
        i=index(pcdata(n),'Mg (pptv)')  
        if(i.eq.1.OR.(i.gt.1.AND.pcdata(n)(i-1:i-1).eq." ")) then
         convratio(n)=24.31* 0.0409/1000.      !  ug/stdm3 = ppbv * MoleWeight * 0.0409 (dc8)
         pcdata(n)='Mg (ug/std m3)'
        endif
	!------------------------------------------------------------------------------------------
        i=index(pcdata(n),'Ca (pptv)')  
        if(i.eq.1.OR.(i.gt.1.AND.pcdata(n)(i-1:i-1).eq." ")) then
         convratio(n)=40.08* 0.0409/1000.      !  ug/stdm3 = ppbv * MoleWeight * 0.0409 (dc8)
         pcdata(n)='Ca (ug/std m3)'
        endif
	!------------------------------------------------------------------------------------------
        i=index(pcdata(n),'Cl (pptv)')  
        if(i.eq.1.OR.(i.gt.1.AND.pcdata(n)(i-1:i-1).eq." ")) then
         convratio(n)=35.45* 0.0409/1000.      !  ug/stdm3 = ppbv * MoleWeight * 0.0409 (dc8)
         pcdata(n)='Cl (ug/std m3)'
        endif
	!------------------------------------------------------------------------------------------
        i=index(pcdata(n),'Br (pptv)')  
        if(i.eq.1.OR.(i.gt.1.AND.pcdata(n)(i-1:i-1).eq." ")) then
         convratio(n)=79.90* 0.0409/1000.      !  ug/stdm3 = ppbv * MoleWeight * 0.0409 (dc8)
         pcdata(n)='Br (ug/std m3)'
        endif
	!------------------------------------------------------------------------------------------
        i=index(pcdata(n),'NO3 (pptv)')  
        if(i.eq.1.OR.(i.gt.1.AND.pcdata(n)(i-1:i-1).eq." ")) then
         convratio(n)=62.01* 0.0409/1000.      !  ug/stdm3 = ppbv * MoleWeight * 0.0409 (dc8)
         pcdata(n)='NO3 (ug/std m3)'
        endif
	!------------------------------------------------------------------------------------------
        i=index(pcdata(n),'SO4 (pptv)')  
        if(i.eq.1.OR.(i.gt.1.AND.pcdata(n)(i-1:i-1).eq." ")) then
         convratio(n)=96.07* 0.0409/1000.      !  ug/stdm3 = ppbv * MoleWeight * 0.0409 (dc8)
         pcdata(n)='SO4 (ug/std m3)'
        endif
	!------------------------------------------------------------------------------------------
        i=index(pcdata(n),'C2O4 (pptv)')  
        if(i.eq.1.OR.(i.gt.1.AND.pcdata(n)(i-1:i-1).eq." ")) then
         convratio(n)=88.* 0.0409/1000.      !  ug/stdm3 = ppbv * MoleWeight * 0.0409 (dc8)
         pcdata(n)='C2O4 (ug/std m3)'
        endif
	!------------------------------------------------------------------------------------------
        i=index(pcdata(n),'Hg (ppqv)')  
        if(i.eq.1.OR.(i.gt.1.AND.pcdata(n)(i-1:i-1).eq." ")) then
         convratio(n)=200.59* 0.0409/1.e-6      !  ug/stdm3 = ppbv * MoleWeight * 0.0409 (dc8)
         pcdata(n)='Hg (ug/std m3)'
        endif
	!------------------------------------------------------------------------------------------
        i=index(pcdata(n),'(molecule/cm3)')  
        if(i.ne.0) then
         convratio(n)=-2      ! molecules/cm3 to ppbv (dc8)
         pcdata(n)(i:i+14)='(ppbv)'
        endif
	!------------------------------------------------------------------------------------------
        i=index(pcdata(n),'(ug/m3)')  ! UNH aerosol
        if(i.ne.0) then
         convratio(n)=-1      ! ug/m3 to ug/std m3 ???
         pcdata(n)(i:i+11)='(ug/std m3)'
        endif
!        i=index(pcdata(n),'(ng/m3)')  ! UNH aerosol
!	   print*, "Index",i
!        if(i.eq.1) then
!         convratio(n)=-3   ! ng/m3 to ug/std m3 ???
!         pcdata(n)='(ug/std m3)'
!        endif
	!------------------------------------------------------------------------------------------
        i=index(pcdata(n),'(ugC/m3)')  ! 
        if(i.ne.0) then
         convratio(n)=-1      ! 
         pcdata(n)(i:i+12)='(ugC/std m3)'
        endif
	!------------------------------------------------------------------------------------------
        i=index(pcdata(n),'pptv')
        if(i.ne.0) then
         convratio(n)=0.001   ! pptv to ppbv
         pcdata(n)(i:i+3)='ppbv'
        endif
	!------------------------------------------------------------------------------------------
        i=index(pcdata(n),'(km)')
        if(i.ne.0) then
         convratio(n)=1000.   ! km to m
         pcdata(n)(i:i+3)='(m) '
        endif
	!------------------------------------------------------------------------------------------
        i=index(pcdata(n),'(Mm-1)')
        if(i.ne.0) then
         convratio(n)=1.e-6   ! /Mm to /m
         pcdata(n)(i:i+5)='(/m)  '
        endif
	!------------------------------------------------------------------------------------------
       write(8,100)trim(pcdata(n))
!------------------------------------------------------------------------------------------
      enddo !do n=1,ndata
!------------------------------------------------------------------------------------------
 100  format(',"',a,'"',$) ! for obs data      
!------------------------------------------------------------------------------------------
      print *, 'test'
      write(8,"(',',$)")
      write(8,101)
 101  format('"NOx (ppbv)","Pot. SO4 (ug/Std m3)"',$)  ! 1
	!------------------------------------------------------------------------------------------
	!------------------------------------------------------------------------------------------
	!<>-<>-<>-<>-<>-<>-<>-Model Output -<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-
	!------------------------------------------------------------------------------------------
	!------------------------------------------------------------------------------------------
	!------------------------------------------------------------------------------------------
!------------------------------------------------------------------------------------------
      write(8,"(',',$)")
      write(8,102)
 102  format('"model_xloc (none)","model_yloc (none)",',
     & '"mtopo (m)","malt (m)"',$)  ! meteo, 6

	do k=1,nvars_3d
             write(8,100)trim(vname_3d(k))// ' ('
     & //trim(units_3d(k))//')'
	 enddo

      write(8,"(',',$)")
       write(8,103)

 103    format('"mpot. SO4 (ug/Std m3)","mWS (m/s)","mWD (deg)",',  
     & '"mRH (%)","mP_hPa","mCWATER_gpm3std"',$)
     
	write(8,'(1x)')
! 103  format('"none","none","m","m"',$)
      !-------------------------------
      !  data line 
      !-------------------------------
	 nline_check=0
!------------------------------------------------------------------------------------------
      first=.true. 
      do while(.true.)          ! starting of each mission
       read(7,'(a15000)',end=99)aline
       nleng_aline = LEN_TRIM(aline)-1
       if(aline(nleng_aline:nleng_aline).eq.",")
     &   aline=aline(1:nleng_aline-1)
!------------------------------------------------------------------------------------------
       call decomma(aline,pdata,ndata)
	  nline_check=nline_check+1
!	  if(nline_check<12)then
!	    print*,"LEN_TRIM(aline)=",LEN_TRIM(aline)
!         print*,"nline_check,ndata,aline,pdata"
!         print*,nline_check,ndata,trim(aline)
!         print*,pdata(ndata-5:ndata)
!	  end if
!------------------------------------------------------------------------------------------
       jday=julianday(mn)
       write(8,'(i3,$)')jday
!------------------------------------------------------------------------------------------
       ihour=int(pdata(l_gmt))/3600.
       iminute=int(pdata(l_gmt))/60-ihour*60
       isecond=mod(int(pdata(l_gmt)),60)
       hourjulian=jday*24.+pdata(l_gmt)/3600.    ! julian hour
!	  print*, 'hourjulian=',hourjulian
!	  print*, 'jday=',jdaytemp
!	  print*, 'ihour-=',ihour
!	  print*, 'iminute-=',iminute
!	  print*, 'isecond-=',isecond
!------------------------------------------------------------------------------------------
       if(ihour.ge.24) then
        ihour=ihour-24
	   jday=jday+1
       endif	
!	  print*, 'jday=',jday
!	  print*, 'ihour-=',ihour
!------------------------------------------------------------------------------------------
       nowtime=ihour*10000+iminute*100+isecond
       nowyear = 2008   ! HHMMSS
       if(first) then
        startime=nowtime
	startjday = jday
	starthour = ihour
	startmin = iminute
	call daymon(nowyear*1000+startjday,mth,dy)
	print*,nowyear*1000+startjday,mth,dy
	print*,starthour,startmin,startjday
	
      
      iflag=setenvvar(tmpnc(mn),outnc(mn))
      if(.not.OPEN3(tmpnc(mn),FSRDWR3,'conv_tracer')) then ! output file does not exit
      NCOLS3D = 1
      NROWS3D = 1
      NLAYS3D=interpzlevs
      MXREC3D=numts
      SDATE3D=nowyear*1000+int(startjday)
      STIME3D=int(startime)
      TSTEP3D=100!sec2time(60) !(hhmmss notation of 1minute)
      print*,SDATE3D,STIME3D,TSTEP3D
      print*,nowyear*1000+int(startjday)
      print*,int(startime)
      print*,sec2time(60)
      
      NVARS3D = nvars_3d + 4
      VNAME3D(1:nvars_3d) = VNAME_3D(1:nvars)
      UNITS3D(1:nvars_3d) = UNITS_3D(1:nvars)
      VDESC3D(1:nvars_3d) = 'Species'
      VTYPE3D(1:NVARS3D)=m3real
      !-----------------------------------------
      VNAME3D(nvars_3d+1)='PotSO4'
      UNITS3D(nvars_3d+1)='ug/Std m3'
      VDESC3D(nvars_3d+1)='Potential SO4'
!      VTYPE3D(nvars_3d+1)=m3real
      !-----------------------------------------
      VNAME3D(nvars_3d+2)='WS'
      UNITS3D(nvars_3d+2)='m/s'
      VDESC3D(nvars_3d+2)='Wind Speed'
!      VTYPE3D(nvars_3d+2)=m3real
      !-----------------------------------------
      VNAME3D(nvars_3d+3)='WD'
      UNITS3D(nvars_3d+3)='deg'
      VDESC3D(nvars_3d+3)='Wind Dir'
!      VTYPE3D(nvars_3d+3)=m3real
      !-----------------------------------------
      VNAME3D(nvars_3d+4)='RH'
      UNITS3D(nvars_3d+4)='%'
      VDESC3D(nvars_3d+4)='Relative Humidity'
!      VTYPE3D(nvars_3d+4)=m3real
      fdesc3d='Altitude Time Cross Section along flight'
      	
      VGTOP3D = BADVAL3  
      
      DO  loop = 1, NLAYS3D
          VGLVS3D( loop ) = outzlevs(loop)
      ENDDO
      
      DO  loop = NLAYS3D+1, MXLAYS3
          VGLVS3D( loop ) = BADVAL3
      ENDDO


      if(.not.OPEN3(tmpnc(mn),FSCREA3,'convert')) 
     1   then	! FSCREA3 FSUNKN3
        print*, 'Error opening output file ',tmpnc(mn)
        stop	
      endif
	
	else 
	
      if (.not. DESC3(tmpnc(mn)) ) then   ! if exit, get information
        print*, 'Error getting info from ',tmpnc(mn) 
         stop
       endif    

      endif    
      !--------------------------------------------------------------------------
	      !endif!	  print*, 'nowtime-=',nowtime
!------------------------------------------------------------------------------------------
!------------------------------------------------------------------------------------------
      open(9,file=outctl(mn))                ! output files
      write(9,"('dset ^',a80)")outnc(1)
      write(9,"('dtype netcdf')")
      write(9,"('title column concentration along with ',
     1 'ARCTAS-DC8 flight')")
      !write(9,"('options big_endian')")
      write(9,"('undef -9999.')")
      write(9,"('xdef 1 linear 1 1')")
      write(9,"('ydef 1 linear 1 1')")
      write(9,"('* zdef is the height in meter')")
      write(9,"('zdef ',i2.2,' levels ',$)")interpzlevs
      write(9,*)outzlevs(1:interpzlevs)
      write(9,"('tdef ',i3.3,' linear ',
     1 i2.2,':',i2.2,'Z',i2.2,a3,i4.4,' 1mn'),$)")numts,int(starthour),
     1 int(startmin),dy,trim(monchar(mth)),nowyear
      write(9,"('vars ',i3,$)")nvars3d
	write(9,'(1x)')
      do L = 1,nvars3d
	 aline=trim(vname3d(L))
	 call lowcase(aline)    ! convert to low case
      write(9,"(a,'=>',a,' ',i2.2,' t,z,y,x ',a,$)")
     1 trim(vname3d(L)),trim(aline),interpzlevs,trim(units3d(L))
	write(9,'(1x)')
      enddo
!------------------------------------------------------------------------------------------
 	write(9,"('endvars')")
	close(9)
       first=.false.
      endif
!------------------------------------------------------------------------------------------
!------------------------------------------------------------------------------------------
      !-----------------------
      !  obs data
      !-----------------------
!------------------------------------------------------------------------------------------
       do n=1,ndata
        write(8,"(',',$)")
        if(pdata(n).gt.-999) then
	 if(abs(convratio(n)+1).le.1e-10) then        ! convratio(n) = -1  ug/m3 to ug/std m3  
	  pdata(n)=pdata(n)*pdata(l_temp)/pdata(l_press)
     &	    *1013/298.0
	 else if(abs(convratio(n)+3).le.1e-10) then        ! convratio(n) = -3  ng/m3 to ug/std m3  
	  pdata(n)=pdata(n)*273
     &	    /298.0*0.001
 	 else if(abs(convratio(n)+4).le.1e-10) then        ! convratio(n) = -3  ng/m3 to ug/std m3  
	  pdata(n)=pdata(n)*1.073*273
     &	    /298.0
        else if(abs(convratio(n)+2).le.1e-10) then   ! convratio(n) = -2  molecules/cm3 to ppbv  
	  pdata(n)=pdata(n)*pdata(l_temp)/pdata(l_press)
     &	    /7.2427e9
         else	 	  
 	  pdata(n)=pdata(n)*convratio(n)
	 endif 
         write(8,"(g12.5,$)")pdata(n)  ! write observed data
	endif 
       enddo  !do n=1,ndata
!------------------------------------------------------------------------------------------
       write(8,"(',',$)")
       if(pdata(l_no).ge.0.and.pdata(l_no2).ge.0) then     ! write observed NOx
         vnox=pdata(l_no)+pdata(l_no2)
	  write(8,'(g10.5,$)')vnox
       else
         vnox=-9999.
       endif

       write(8,"(',',$)")
	    opso4=-9999.
          if(pdata(l_so2).ge.0.and.pdata(l_amsso4).ge.0) then     ! write observed NOx
          opso4=(pdata(l_so2)*0.0409*96.07*64/64)+ (pdata(l_amsso4)) 
	     write(8,'(g10.5,$)')opso4
          else
          opso4=-9999.
          endif
!------------------------------------------------------------------------------------------
	!------------------------------------------------------------------------------------------
	!------------------------------------------------------------------------------------------
	!<>-<>-<>-<>-<>-<>-<>-Interpolating Model values -<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-
	!------------------------------------------------------------------------------------------
	!------------------------------------------------------------------------------------------
	!------------------------------------------------------------------------------------------
	!<>-<>-<>-<>-<>-<>-<>-Model grid (i,j) location -<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-
	!------------------------------------------------------------------------------------------
          print *, 'test'
	
      if(.not.INTERP3('METEO3D','AGL','pathway',
     1	   nowyear*1000+jday,nowtime,imax*jmax*kmmax,trheight)) then
        print*, 'Error in reading HEIGHT3D'
	  stop
      endif      
      if(.not.INTERP3('METEO3D','T','pathway',
     1	   nowyear*1000+jday,nowtime,imax*jmax*kmmax,trtemp)) then
        print*, 'Error in reading HEIGHT3D'
	  stop
      endif      
      if(.not.INTERP3('METEO3D','P','pathway',
     1	   nowyear*1000+jday,nowtime,imax*jmax*kmmax,trpress)) then
        print*, 'Error in reading HEIGHT3D'
	  stop
      endif      
      !iflag=close3('METEO3D') 
	!------------------------------------------------------------------------------------------
      do i=1,itrace
       do j=1,jtrace       
        do k=1,kmmax
        trheight(i,j,k)=trtopo(i,j)+trheight(i,j,k)    ! vertical altitude
        enddo
       enddo
      enddo
	 print*, trheight(100,100,1)
!------------------------------------------------------------------------------------------
        call llij_ps( pdata(l_lat), pdata(l_lon), 90.00, -40.00, 
     &                xlat(1,1),xlon(1,1), x, y, 60000.)  ! for cross points
	!------------------------------------------------------------------------------------------
	   x=x-ioff!-0.5                    ! locate horizontal grid in this domain
        y=y-joff!-0.5
	!------------------------------------------------------------------------------------------
	 write(8,"(2(',',f9.3),$)")x,y     ! print out grid locations related to domain
	!------------------------------------------------------------------------------------------
	xratio=x-int(x)
	yratio=y-int(y)
	!------------------------------------------------------------------------------------------
	if(x.gt.imax.or.x.lt.1.or.y.gt.jmax.or.y.lt.1.) then
	 do L=1,nvars_3d+nvars_2d+2  ! 6 meteorological
	  write(8,"(',',$)")
	 enddo
	 print*,'out of model domain ',pdata(l_lat),pdata(l_lon),x,y
	 goto 50
	endif
	!------------------------------------------------------------------------------------------
	 fheight=pdata(l_alt)
!	 print*, 'fheight=',fheight
	!------------------------------------------------------------------------------------------
	
        do mlev=1,kmax
         conzhlevs(mlev)=(1-yratio)*(trheight(int(x),int(y),mlev)*
     &   (1-xratio)+trheight(int(x)+1,int(y),mlev)*xratio)+yratio*
     &   (trheight(int(x),int(y)+1,mlev)*(1-xratio)+
     &    trheight(int(x)+1,int(y)+1,mlev)*xratio)
        end do 

		do mlev=1,kmax
	 		if(fheight.le.conzhlevs(mlev)) goto 20
		enddo        
	        
	!------------------------------------------------------------------------------------------
 20     kp=mlev
!        print*, kp, mlev	                                ! locate vertical height	
	!------------------------------------------------------------------------------------------
	 if(kp.eq.1) then  !if below the lowest layer
	  kp=2
	  zratio=0.
	!------------------------------------------------------------------------------------------
	 else if(fheight.ge.conzhlevs(kmax)) then !if above top
	  kp=kmax
	  zratio=1.
	!------------------------------------------------------------------------------------------
	 else 
         zratio=(fheight-conzhlevs(kp-1))/
     &	(conzhlevs(kp)-conzhlevs(kp-1))
        endif 
	       
	       trheight_xy=conzhlevs(kp)*zratio+conzhlevs(kp-1)*(1-zratio)
	       
	 	
        do mlev=1,kmax
         contemplevs(mlev)=(1-yratio)*(trtemp(int(x),int(y),mlev)*
     &   (1-xratio)+trtemp(int(x)+1,int(y),mlev)*xratio)+yratio*
     &   (trtemp(int(x),int(y)+1,mlev)*(1-xratio)+
     &    trtemp(int(x)+1,int(y)+1,mlev)*xratio)
        end do 
	    temp1=contemplevs(kp)*zratio+contemplevs(kp-1)*(1-zratio)

	 	
        do mlev=1,kmax
         conpresslevs(mlev)=(1-yratio)*(trpress(int(x),int(y),mlev)*
     &   (1-xratio)+trpress(int(x)+1,int(y),mlev)*xratio)+yratio*
     &   (trpress(int(x),int(y)+1,mlev)*(1-xratio)+
     &    trpress(int(x)+1,int(y)+1,mlev)*xratio)
        end do 
	
	press1=conpresslevs(kp)*zratio+conpresslevs(kp-1)*(1-zratio)
!------------------------------------------------------------------------------------------
	!------------------------------------------------------------------------------------------
	!<>-<>-<>-<>-<>-<>-<>-topography/model layer heights -<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-
	!------------------------------------------------------------------------------------------
	!------------------------------------------------------------------------------------------
      !-- calculating trtopo and trheight @(x,y)
	!------------------------------------------------------------------------------------------
        topo_xy=(1-yratio)*(trtopo(int(x),int(y))*
     &   (1-xratio)+trtopo(int(x)+1,int(y))*xratio)+yratio*
     &   (trtopo(int(x),int(y)+1)*(1-xratio)+
     3    trtopo(int(x)+1,int(y)+1)*xratio)
	!------------------------------------------------------------------------------------------
!        do mlev=1,kmax
!         conlevs(mlev)=(1-yratio)*(trheight(int(x),int(y),mlev)*
!     &   (1-xratio)+trheight(int(x)+1,int(y),mlev)*xratio)+yratio*
!     &   (trheight(int(x),int(y)+1,mlev)*(1-xratio)+
!     &    trheight(int(x)+1,int(y)+1,mlev)*xratio)
!        end do 
!------------------------------------------------------------------------------------------
        write(8,"(2(',',f11.3),$)")topo_xy,trheight_xy    
	!------------------------------------------------------------------------------------------
!------------------------------------------------------------------------------------------
!------------------------------------------------------------------------------------------------------     
!------------------------------------------------------------------------------------------------------     
!------------------------------------------------------------------------------------------------------     
!------------------------------------------------------------------------------------------------------     
	!------------------------------------------------------------------------------------------
	!<>-<>-<>-<>-<>-<>-<>-Interpolate 3d variables -<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-
	!------------------------------------------------------------------------------------------
	!------------------------------------------------------------------------------------------
	!<>-<>-<>-<>-<>-<>-<>-*** U ***-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-
	!------------------------------------------------------------------------------------------
	 do L=1,nvars_3d
 	 if(.not.INTERP3(vfile_3D(L),vname_3D(L),'meteo',
     1	   nowyear*1000+jday,nowtime,imax*jmax*kmmax,work)) then
           print*,'interp error at',
     1	   nowyear*1000+jday,nowtime,vname_3D(L),vfile_3D(L)	 
	   stop
	 endif
	!------------------------------------------------------------------------------------------
	do mlev=1,kmax
	conlevs(mlev)=(1-yratio)*(work(int(x),int(y),mlev)*
     &	(1-xratio)+work(int(x)+1,int(y),mlev)*xratio)+yratio*
     &   (work(int(x),int(y)+1,mlev)*(1-xratio)+
     &	work(int(x)+1,int(y)+1,mlev)*xratio)
	    end do 
    !------------------------------------------------------------------------------------------
	 out3d=conlevs(kp)*zratio+conlevs(kp-1)*(1-zratio)
        
	if(vname_3D(L).eq.'U')  then 
		u=out3d
		conulevs = conlevs
	endif
		
        if(vname_3D(L).eq.'V')    then 
		v=out3d
		convlevs = conlevs
	endif
        
	if(vname_3D(L).eq.'T')    then 
		temp=out3d
		contemplevs = conlevs
	endif
        
	if(vname_3D(L).eq.'P')    then 
		press=out3d
		conpresslevs = conlevs
	endif
        
	if(vname_3D(L).eq.'VAPOR')    then 
		vapor=out3d
		convaplevs = conlevs
	endif
        
	if(vname_3D(L).eq.'CWATER') cwater=out3d
        if(vname_3D(L).eq.'RWATER') rwater=out3d

	 if((index(UNITS_3D( L ),'ug/Std m3')).ne.0) then
     	out3d = out3d*temp1/press1*101300.0/298.0
	conlevs = conlevs*contemplevs/conpresslevs*101300.0/298.0
	endif

        if(vname_3D(L).eq.'SO2')  then
     	totso2 =out3d*0.0409*96.07*64./64.
	conso2levs = conlevs*0.0409*96.07*64./64.
	endif
	
!        if(vname_3D(L).eq.'SO4'.and. 
!     &((index(UNITS_3D( L ),'(ug/Std m3)')).ne.0))  then
        if(vname_3D(L).eq.'SO4')  then
     	tpso4 =totso2+out3d
	conpso4levs = conlevs+conso2levs
	endif

 	 write(8,"(',',g10.5,$)")out3d
	 	!------------------------------------------------------------------------------------------

               CALL interpv_linear (kmax, conlevs,
     &        conzhlevs, interpzlevs,
     &        convoutzlevs,outzlevs)
!--------------------------------------------------------------------------
              DO loop2=1,interpzlevs
!			  print*,conzhlevs(loop2,i),topo_xy(i)
                 IF (outzlevs(loop2).LE.topo_xy) THEN
                    convoutzlevs(loop2)=-9999.          !no value underneath terrain height
                 ENDIF
          !outncdata(loop2) = outdata(loop2,i)
!	print*,conlevs(loop2,i), outncdata(loop2)
              ENDDO
!              DO loop2=1,kmax
!	print*,conlevs(loop2,i), outncdata(:)
!	  do mlev=1,kmax
!          outncdata(mlev) = conlevs(mlev,i)
!	  enddo !do mlev=1,kmax

         	if(.not.write3(tmpnc(mn),vname_3d(L),nowyear*1000+jday,
     1	 nowtime,convoutzlevs)) then
         	 print*,'write error ',outnc(mn),vname_3d(L),nowdate,nowtime
	 	 stop
	 	endif
!--------------------------------------------------------------------------

      enddo
         
	  !conwslevs = sqrt(conulevs*conulevs + convlevs*convlevs)
                write(8,"(',',$)")
		write(8,'(g10.5,$)') tpso4 ! write totsO2 after biomass co tracers
               CALL interpv_linear (kmax, conpso4levs,
     &        conzhlevs, interpzlevs,
     &        convoutzlevs,outzlevs)
!--------------------------------------------------------------------------
              DO loop2=1,interpzlevs
!			  print*,conzhlevs(loop2,i),topo_xy(i)
                 IF (outzlevs(loop2).LE.topo_xy) THEN
                    convoutzlevs(loop2)=-9999.          !no value underneath terrain height
                 ENDIF
          !outncdata(loop2) = outdata(loop2,i)
!	print*,conlevs(loop2,i), outncdata(loop2)
              ENDDO
!              DO loop2=1,kmax
!	print*,conlevs(loop2,i), outncdata(:)
!	  do mlev=1,kmax
!          outncdata(mlev) = conlevs(mlev,i)
!	  enddo !do mlev=1,kmax

         	if(.not.write3(tmpnc(mn),'PotSO4',nowyear*1000+jday,
     1	 nowtime,convoutzlevs)) then
         	 print*,'write error ',outnc(mn),'PotSO4 ',nowdate,nowtime
	 	 stop
	 	endif !        endif
	!------------------------------------------------------------------------------------------
!------------------------------------------------------------------------------------------
    !<>-<>-<>-<>-<>-<>-<>-*** Assign met varaibles <  1st met end time ***-<>-<>-<>-<>-<>
    !------------------------------------------------------------------------------------------
!	u=met3d(1)
!	v=met3d(2)
!	temp=met3d(3)
!	press=met3d(4)
!	vapor=met3d(5)
!	cwater=met3d(6)!Cloud water content in Kg/kg
!	rwater=met3d(7)!Rain water content in Kg/kg
	 
	!------------------------------------------------------------------------------------------
	!------------------------------------------------------------------------------------------
	!<>-<>-<>-<>-<>-<>-<>-*** wind speed ***-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-
	!------------------------------------------------------------------------------------------
	  ws=sqrt(u*u+v*v)		! modeling wind speed
   !------------------------------------------------------------------------------------------
	write(8,"(',',f5.2,$)")ws

 	do k = 1,kmax
	 conwslevs(k) = sqrt(conulevs(k)*conulevs(k) + 
     &			convlevs(k)*convlevs(k))
       enddo

               CALL interpv_linear (kmax, conwslevs,
     &        conzhlevs, interpzlevs,
     &        convoutzlevs,outzlevs)
!--------------------------------------------------------------------------
              DO loop2=1,interpzlevs
!			  print*,conzhlevs(loop2,i),topo_xy(i)
                 IF (outzlevs(loop2).LE.topo_xy) THEN
                    convoutzlevs(loop2)=-9999.          !no value underneath terrain height
                 ENDIF
          !outncdata(loop2) = outdata(loop2,i)
!	print*,conlevs(loop2,i), outncdata(loop2)
              ENDDO
!              DO loop2=1,kmax
!	print*,conlevs(loop2,i), outncdata(:)
!	  do mlev=1,kmax
!          outncdata(mlev) = conlevs(mlev,i)
!	  enddo !do mlev=1,kmax

         	if(.not.write3(tmpnc(mn),'WS',nowyear*1000+jday,
     1	 nowtime,convoutzlevs)) then
         	 print*,'write error ',outnc(mn),'WS ',nowdate,nowtime
	 	 stop
	 	endif    
!------------------------------------------------------------------------------------------
    !------------------------------------------------------------------------------------------
    !<>-<>-<>-<>-<>-<>-<>-***Compute wind direction ***-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-
    !------------------------------------------------------------------------------------------
	    cone = 1
	    diff = pdata(l_lon) - stdlon
	    if (diff.gt.180.) then
		 diff = diff - 360.
	    endif
    !------------------------------------------------------------------------------------------
	    if (diff.lt.-180.) then
		 diff = diff + 360.
	    endif
    !------------------------------------------------------------------------------------------
	    alpha = diff * cone * paiv
	    if ( pdata(l_lat) .lt. 0.) then
		 alpha = -1. * alpha
	    endif
    !------------------------------------------------------------------------------------------
	    !print*, "diff, alpha: ", diff, alpha
    !------------------------------------------------------------------------------------------
	    v_g = v*cos(alpha) - u*sin(alpha)
	    u_g = v*sin(alpha) + u*cos(alpha)
    !------------------------------------------------------------------------------------------
    !------------------------------------------------------------------------------------------
    !<>-<>-<>-<>-<>-<>-<>-***Output wind direction ***-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-
    !------------------------------------------------------------------------------------------
	    if(u_g.eq.0) then   ! calculate wind direction in RAMS coordinate
		if(v_g.lt.0) then
		 wd=0.
		else
		 wd=180.
		endif
	    else
		wd=atan(v_g/u_g)/paiv
    !------------------------------------------------------------------------------------------
		!print*, "wd1: ", wd
		if(u_g.lt.0) then
		 wd=90.-wd
		!print*, "wd2: ", wd
		else
		 wd=270.-wd
		endif
	    endif
    !------------------------------------------------------------------------------------------
	    write(8,"(',',f6.2,$)")wd
    !------------------------------------------------------------------------------------------
 	do k = 1,kmax
	    v_g = convlevs(k)*cos(alpha) - conulevs(k)*sin(alpha)
	    u_g = convlevs(k)*sin(alpha) + conulevs(k)*cos(alpha)
    !------------------------------------------------------------------------------------------
    !------------------------------------------------------------------------------------------
    !<>-<>-<>-<>-<>-<>-<>-***Output wind direction ***-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-
    !------------------------------------------------------------------------------------------
	    if(u_g.eq.0) then   ! calculate wind direction in RAMS coordinate
		if(v_g.lt.0) then
		 wd=0.
		else
		 wd=180.
		endif
	    else
		wd=atan(v_g/u_g)/paiv
    !------------------------------------------------------------------------------------------
		!print*, "wd1: ", wd
		if(u_g.lt.0) then
		 wd=90.-wd
		!print*, "wd2: ", wd
		else
		 wd=270.-wd
		endif
	    endif
	    conwdlevs(k)=wd	
	enddo
	   !print*, "v,u: ", v, u
               CALL interpv_linear (kmax, conwdlevs,
     &        conzhlevs, interpzlevs,
     &        convoutzlevs,outzlevs)
!--------------------------------------------------------------------------
              DO loop2=1,interpzlevs
!			  print*,conzhlevs(loop2,i),topo_xy(i)
                 IF (outzlevs(loop2).LE.topo_xy) THEN
                    convoutzlevs(loop2)=-9999.          !no value underneath terrain height
                 ENDIF
          !outncdata(loop2) = outdata(loop2,i)
!	print*,conlevs(loop2,i), outncdata(loop2)
              ENDDO
!              DO loop2=1,kmax
!	print*,conlevs(loop2,i), outncdata(:)
!	  do mlev=1,kmax
!          outncdata(mlev) = conlevs(mlev,i)
!	  enddo !do mlev=1,kmax

         	if(.not.write3(tmpnc(mn),'WD',nowyear*1000+jday,
     1	 nowtime,convoutzlevs)) then
         	 print*,'write error ',outnc(mn),'WD ',nowdate,nowtime
	 	 stop
	 	endif         !print*, "v_g,u_g: ", v_g, u_g
        !print*, "wd: ", wd
        !print*, "x, y: ", nint(x),nint(y)
        !print*, "lat: ", pdata(l_lat)
        !print*, "lon: ", pdata(l_lon)
        !print*, "stdlon: ", stdlon    
    !------------------------------------------------------------------------------------------
    !<>-<>-<>-<>-<>-<>-<>-***Compute realtive humidity ***-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-
    !------------------------------------------------------------------------------------------
	 rh=100.*vapor/QSAT(ESAT( 	   ! computing relative humudity
     &		    temp),press/1000)		  !convert to KPa
    !------------------------------------------------------------------------------------------
	    write(8,"(1(',',f6.2),',',f7.1,$)")rh,press/100.
    !------------------------------------------------------------------------------------------
      do k= 1,kmax
       conrhlevs(k) = 100.*convaplevs(k)/QSAT(ESAT( 	   ! computing relative humudity
     &		    contemplevs(k)),conpresslevs(k)/1000)
      enddo
               CALL interpv_linear (kmax, conrhlevs,
     &        conzhlevs, interpzlevs,
     &        convoutzlevs,outzlevs)
!--------------------------------------------------------------------------
              DO loop2=1,interpzlevs
!			  print*,conzhlevs(loop2,i),topo_xy(i)
                 IF (outzlevs(loop2).LE.topo_xy) THEN
                    convoutzlevs(loop2)=-9999.          !no value underneath terrain height
                 ENDIF
          !outncdata(loop2) = outdata(loop2,i)
!	print*,conlevs(loop2,i), outncdata(loop2)
              ENDDO
!              DO loop2=1,kmax
!	print*,conlevs(loop2,i), outncdata(:)
!	  do mlev=1,kmax
!          outncdata(mlev) = conlevs(mlev,i)
!	  enddo !do mlev=1,kmax

         	if(.not.write3(tmpnc(mn),'RH',nowyear*1000+jday,
     1	 nowtime,convoutzlevs)) then
         	 print*,'write error ',outnc(mn),'RH ',nowdate,nowtime
	 	 stop
	 	endif     !<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-
    !------------------------------------------------------------------------------------------
	 cwater=1000*(cwater+rwater)/1.28				 ! air density STD in kg/m3
											   ! convert to g/std m3
	 write(8,"(',',g10.5,$)")cwater
	!------------------------------------------------------------------------------------------
	 !print*,'complete met3d ',nowtime
!------------------------------------------------------------------------------------------------------     
!------------------------------------------------------------------------------------------------------     
!------------------------------------------------------------------------------------------------------     
!------------------------------------------------------------------------------------------------------     
	!------------------------------------------------------------------------------------------
	!<>-<>-<>-<>-<>-<>-<>-*** Begin tracer interpolate ***-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-
	!------------------------------------------------------------------------------------------
	!<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-
		!------------------------------------------------------------------------------------------
	!<>-<>-<>-<>-<>-<>-<>-*** Convert Hg from ppbv to ug/stdm3 ***-<>-<>-<>-<>-<>
	!------------------------------------------------------------------------------------------
!        if(name_tracer(L).eq.'Hg') conc(L)=conc(L)*
!     &  200.59* 0.0409
	   !ug/std m3 =ppbv * MoleWeight * 0.0409
	
	!---------------------------------------------------------------------------------------!------------------------------------------------------------------------------------------

 50	write(8,'(1x)')
	!------------------------------------------------------------------------------------------
       enddo                             ! end of one file 
 99    print*,'end of file ',afile(mn)
	!------------------------------------------------------------------------------------------
       close(7)
       close(8)
	!------------------------------------------------------------------------------------------
       enddo                             ! end of total
       print*,'end of total process'
	!------------------------------------------------------------------------------------------
       end
!------------------------------------------------------------------------------------------------------     
!------------------------------------------------------------------------------------------------------     
!------------------------------------------------------------------------------------------------------     
!------------------------------------------------------------------------------------------------------     
	!------------------------------------------------------------------------------------------
	!<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-*** Subroutines ***-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>
	!------------------------------------------------------------------------------------------
	!------------------------------------------------------------------------------------------
      subroutine handle_err(iflag)
      print*,'error occurred in netcdf ',iflag
      stop
      end
	!------------------------------------------------------------------------------------------
	!<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-
	!------------------------------------------------------------------------------------------
       subroutine decomma(aline,data,ndata)  ! decode comma delimited data
       character*(*)aline
       real data(400)
       nlength=len_trim(aline)
       if(nlength.le.0) then
        ndata=0
	  return
       endif 	
       ndata=1
       L2=index(aline,',')
       if(L2.eq.0) then   ! no comma
        read(aline,*)data(1)
        return
       else
        ndata=0	
       endif		
       L1=0
       do while(L2.lt.nlength)
	  L2=index(aline(L1+1:nlength),',')+L1
	  if(L2.eq.L1) L2=nlength+1
	   ndata=ndata+1
	  if(L2.eq.L1+1) then  ! empty one
	   data(ndata)=-9999.
	  else
	   read(aline(L1+1:L2-1),*)data(ndata)
	  endif 
	   L1=L2
       enddo
       end
	!------------------------------------------------------------------------------------------
	!<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-
	!------------------------------------------------------------------------------------------
       subroutine decommac(aline,pcdata,ndata)  ! decode comma delimited data
       character*(*)aline
       character*80 pcdata(200)
       nlength=len_trim(aline)
       if(nlength.le.0) then
        ndata=0
	   return
       endif 	
	!------------------------------------------------------------------------------------------
       ndata=1
       L2=index(aline,',')
       if(L2.eq.0) then   ! no comma
        pcdata(1)=aline
        return
       else
        ndata=0	
       endif		
       L1=0
       do while(L2.lt.nlength)
	  L2=index(aline(L1+1:nlength),',')+L1
	  if(L2.eq.L1) L2=nlength+1
	  ndata=ndata+1
	  if(L2.eq.L1+1) then  ! empty one
	   pcdata(ndata)=''
	  else
	  pcdata(ndata)=aline(L1+1:L2-1)
	  endif 
	  L1=L2
       enddo
       end
!------------------------------------------------------------------------------------------
!<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-
!------------------------------------------------------------------------------------------
!     Populate your structure by calling the map_set routine:
!         CALL map_set(code,lat1,lon1,knowni,knownj,dx,stdlon,truelat1,truelat2,proj)
!       where:
!         code (input) = one of PROJ_LATLON, PROJ_MERC, PROJ_LC, PROJ_PS,
!                        PROJ_GAUSS, or PROJ_ROTLL
!         lat1 (input) = Latitude of grid origin point (i,j)=(1,1)
!                         (see assumptions!)
!         lon1 (input) = Longitude of grid origin
!
!         knowni (input) = origin point, x-location (will be 1 for WRF-STEM)
!         knownj (input) = origin point, y-location (will be 1 for WRF-STEM)
!
!         dx (input) = grid spacing in meters (ignored for LATLON projections)
!
!         stdlon (input) = Standard longitude for PROJ_PS and PROJ_LC,
!               deltalon (see assumptions) for PROJ_LATLON,
!               ignored for PROJ_MERC
!
!         truelat1 (input) = 1st true latitude for PROJ_PS, PROJ_LC, and
!                PROJ_MERC, deltalat (see assumptions) for PROJ_LATLON
!------------------------------------------------------------------------------------------
! IF ( proj_code == PROJ_PS ) THEN
! PRINT '(A,I2)', 'The following are mandatory parameters for projection code : ', proj_code
! PRINT '(A)', ' truelat1, lat1, lon1, knonwi, knownj, stdlon, dx'
! truelat1  First true latitude (all projections)
! lat1      SW latitude (1,1) in degrees (-90->90N)
! lon1      SW longitude (1,1) in degrees (-180->180E)
! knowni X-location of known lat/lon
! knownj Y-location of known lat/lon
! stdlon Longitude parallel to y-axis (-180->180E)
! dx Grid spacing in meters at truelats, used
!------------------------------------------------------------------------------------------
	!------------------------------------------------------------------------------------------
	!<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-
	!------------------------------------------------------------------------------------------
      SUBROUTINE llij_ps( lat, lon, proj_truelat1, proj_stdlon, 
     1                    proj_lat1, proj_lon1, i, j, proj_dx)

! Given latitude (-90 to 90), longitude (-180 to 180), and the
      ! standard polar-stereographic projection information via the 
      ! public proj structure, this routine returns the i/j indices which
      ! if within the domain range from 1->nx and 1->ny, respectively.
      
      IMPLICIT NONE
      
      REAL, PARAMETER    :: pi = 3.1415927
      REAL, PARAMETER    :: deg_per_rad = 180./pi
      REAL, PARAMETER    :: rad_per_deg = pi/180.  
      REAL, PARAMETER    :: earth_radius_m=6370000.0
      
      ! Delcare input arguments for llij_ps      
      REAL, INTENT(IN)               :: lat
      REAL, INTENT(IN)               :: lon
      REAL, INTENT(IN)               :: proj_truelat1, proj_stdlon
      REAL, INTENT(IN)               :: proj_dx, proj_lat1, proj_lon1  
      
      ! Declare output arguments     
      REAL, INTENT(OUT)              :: i !(x-index)
      REAL, INTENT(OUT)              :: j !(y-index)
      
! Initializes a polar-stereographic map projection from the partially
      ! filled proj structure. This routine computes the radius to the
      ! southwest corner and computes the i/j location of the pole for use
      ! in llij_ps and ijll_ps.
  
      ! Local vars
      REAL                              :: ala1, ala
      REAL                              :: alo1, alo
      REAL                              :: reflon
      REAL                              :: scale_top
      REAL                              :: proj_rebydx
      REAL                              :: proj_hemi
      REAL                              :: proj_rsw, rm
      REAL                              :: proj_polei
      REAL                              :: proj_polej
      
      REAL 				:: proj_knownj, proj_knowni
      
      proj_knownj=1.00  ! this is for proj_lat1 
      proj_knowni=1.00  ! this is for proj_lon1 
      
      ! Executable code
      reflon = proj_stdlon + 90.
      proj_rebydx = earth_radius_m / proj_dx
      
      if(proj_truelat1.lt.0) then
            proj_hemi = -1.
      else  
            proj_hemi = 1
      endif  
        
      ! Compute numerator term of map scale factor
      scale_top = 1. + proj_hemi * SIN(proj_truelat1 * rad_per_deg)
  
      ! Compute radius to lower-left (SW) corner
      ala1 = proj_lat1 * rad_per_deg
      proj_rsw = proj_rebydx*COS(ala1)*scale_top
     1           /(1.+proj_hemi*SIN(ala1))
  
      ! Find the pole point
      alo1 = (proj_lon1 - reflon) * rad_per_deg
      
      proj_polei = proj_knowni - proj_rsw * COS(alo1)
      proj_polej = proj_knownj - proj_hemi * proj_rsw * SIN(alo1)

      ! from llij_ps
      ! Find radius to desired point
      
      ala = lat * rad_per_deg
      rm = proj_rebydx * COS(ala) * scale_top
     1     /(1. + proj_hemi *SIN(ala))
      alo = (lon - reflon) * rad_per_deg
      i = proj_polei + rm * COS(alo)
      j = proj_polej + proj_hemi * rm * SIN(alo)
   
      RETURN


      END SUBROUTINE llij_ps

	!------------------------------------------------------------------------------------------
	!<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-
	!------------------------------------------------------------------------------------------

      SUBROUTINE ijll_ps( i, j, proj_truelat1, proj_stdlon, 
     &                    proj_lat1, proj_lon1, lat, lon, proj_dx)
 
      ! This is the inverse subroutine of llij_ps.  It returns the 
      ! latitude and longitude of an i/j point given the projection info 
      ! structure.  
  
      IMPLICIT NONE
      
      REAL, PARAMETER    :: pi = 3.1415927
      REAL, PARAMETER    :: deg_per_rad = 180./pi
      REAL, PARAMETER    :: rad_per_deg = pi / 180.  
      REAL, PARAMETER    :: earth_radius_m=6370000.0
      
      
      ! Declare input arguments
      REAL, INTENT(IN)               :: i    ! Column
      REAL, INTENT(IN)               :: j    ! Row
      REAL, INTENT(IN)               :: proj_truelat1, proj_stdlon
      REAL, INTENT(IN)               :: proj_dx, proj_lat1, proj_lon1  
 
      ! Declare output arguments
      REAL, INTENT(OUT)                   :: lat     ! -90 -> 90 north
      REAL, INTENT(OUT)                   :: lon     ! -180 -> 180 East
  
      ! Local variables
      REAL                                :: reflon
      REAL                                :: scale_top
      REAL                                :: xx,yy
      REAL                                :: gi2, r2
      REAL                                :: arccos
      REAL                                :: proj_hemi
      REAL                                :: proj_rsw
      REAL                                :: ala1
      REAL                                :: alo1
      REAL                                :: proj_rebydx
      REAL                                :: proj_polei
      REAL                                :: proj_polej
      REAL 				  :: proj_knownj, proj_knowni
      
      proj_knownj=1.00  ! this is for proj_lat1 
      proj_knowni=1.00  ! this is for proj_lon1 
      
      
      ! Executable code
      reflon = proj_stdlon + 90.
      proj_rebydx = earth_radius_m / proj_dx
      
      if(proj_truelat1.lt.0) then
            proj_hemi = -1.
      else  
            proj_hemi = 1
      endif  
        
      ! Compute numerator term of map scale factor
      scale_top = 1. + proj_hemi * SIN(proj_truelat1 * rad_per_deg)
  
      ! Compute radius to lower-left (SW) corner
      ala1 = proj_lat1 * rad_per_deg
      proj_rsw = proj_rebydx*COS(ala1)*scale_top
     &           /(1.+proj_hemi*SIN(ala1))
  
      ! Find the pole point
      alo1 = (proj_lon1 - reflon) * rad_per_deg
      proj_polei = proj_knowni - proj_rsw * COS(alo1)
      proj_polej = proj_knownj - proj_hemi * proj_rsw * SIN(alo1)

      ! from ijll_ps
      ! Compute radius to point of interest
      xx = i - proj_polei
      yy = (j - proj_polej) * proj_hemi
      r2 = xx**2 + yy**2
   
      ! Now the magic code
      IF (r2 .EQ. 0.) THEN 
         lat = proj_hemi * 90.
         lon = reflon
      ELSE
         gi2 = (proj_rebydx * scale_top)**2.
         lat = deg_per_rad * proj_hemi * ASIN((gi2-r2)/(gi2+r2))
         arccos = ACOS(xx/SQRT(r2))
         IF (yy .GT. 0) THEN
            lon = reflon + deg_per_rad * arccos
         ELSE
            lon = reflon - deg_per_rad * arccos
         ENDIF
      ENDIF
    
      ! Convert to a -180 -> 180 East convention
      IF (lon .GT. 180.) lon = lon - 360.
      IF (lon .LT. -180.) lon = lon + 360.

      RETURN
   
      END SUBROUTINE ijll_ps
	!------------------------------------------------------------------------------------------
	!<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-<>-
	!------------------------------------------------------------------------------------------
!------------------------------------------------------------------------------------------------------     
!------------------------------------------------------------------------------------------------------     
!------------------------------------------------------------------------------------------------------     
!------------------------------------------------------------------------------------------------------     
!==========================================================================
	SUBROUTINE interpv_linear( num_source_layer, source_data, 
     & source_layer,num_target_layer,target_data,target_layer )
   !------------------------------------------------------------------------
   ! Description:
   !    carry out vertical linear interpolation
   ! 
   !-----------------------------------------------------------------------
 
!   IMPLICIT none

   !---arguments and their descriptions 
      INTEGER, INTENT(IN) :: num_source_layer                       ! number of source levels
      REAL, INTENT(IN)    :: source_data(num_source_layer)          ! source data
      REAL, INTENT(IN)    :: source_layer(num_source_layer)         ! source level value( height ...)
      INTEGER, INTENT(IN) :: num_target_layer                       !number of target levels
      REAL, INTENT(OUT)   :: target_data(num_target_layer)          ! target data
      REAL, INTENT(IN)    :: target_layer(num_target_layer)         ! target level value( height ...)

   !---local variables
      INTEGER :: layerHigh_kk
      INTEGER :: layerLow_kk 
      INTEGER :: k_loop, k_loop2
      CHARACTER (LEN=256) :: mesg
      CHARACTER (LEN=40) :: program='interpv_linear'
 
   !---start of executable code

      DO k_loop=1, num_target_layer

 		DO k_loop2=1, num_source_layer              ! assume values of layer levels (either sigma or height)
                                                  ! increase  as k_loop2 increases
         	 IF(source_layer(k_loop2) >= target_layer(k_loop)) EXIT
         	  IF(k_loop2 == num_source_layer) THEN
             target_data(k_loop)=-999.
            GO TO 30                               ! no extrapolation above the source data top 
           ENDIF
      	ENDDO

       IF(k_loop2 /=1) THEN
         layerLow_kk=k_loop2-1
         layerHigh_kk=k_loop2
       ELSE
         layerLow_kk=k_loop2
         layerHigh_kk=k_loop2+1
       ENDIF

      ! weighted interpolation
      target_data(k_loop)= 
     &((source_layer(layerHigh_kk)-target_layer(k_loop))*
     & source_data(layerLow_kk) 
     &   +(target_layer(k_loop)-source_layer(layerLow_kk))*
     &  source_data(layerHigh_kk)) 
     &   /(source_layer(layerHigh_kk)-source_layer(layerLow_kk))

30 	 CONTINUE
   	 ENDDO  !k_loop

      END SUBROUTINE interpv_linear
!------------------------------------------------------------------------------------------------------     
!------------------------------------------------------------------------------------------------------     
      subroutine lowcase(aline)
      character*(*) aline
      length=len_trim(aline)
      do n=1,length
       if(aline(n:n).le.'Z'.and.aline(n:n).ge.'A') then
        aline(n:n)=char(ichar(aline(n:n))-ichar('A')+ichar('a'))
       else if(aline(n:n).eq.'-') then
        aline(n:n)='_'
       endif
      enddo
      end 	
  
