#!/bin/csh
#-------------------------------------------------------------------------------
make clean -f tracer-arctas-249x249-1flight-R13-dc8-altcorrect-3d-species-curtain.mk
make -f tracer-arctas-249x249-1flight-R13-dc8-altcorrect-3d-species-curtain.mk
#-------------------------------------------------------------------------------
set monthday = (31 29 31 30 31 30 31 31 30 31 30 31) # for 2008
set month = ( 3 3 4 4 4 4 4 4 4 4 4 6 6 6 6 6 6 7 7 7 7 7 7 7)
set date =  ( 1 1 1 4 5 8 9 12 16 17 19 18 20 22 24 26 29 1  4  5  8  9  10 13)  
# flight#     1 2 3 4 5 6 7  8  9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24
#-------------------------------------------------------------------------------
set sflight = 3  # start flight #
#set eflight = 11  # end flight #
#set sflight = $#month  # start flight #
set eflight = 3 # end flight #
set monthchar = ( "jan" "feb" "mar" "apr" "may" "jun" "jul" "aug" "sep" "oct" "nov" "dec" ) 
set monthchar2 = ( "JAN" "FEB" "MAR" "APR" "MAY" "JUN" "JUL" "AUG" "SEP" "OCT" "NOV" "DEC" ) 
#-------------------------------------------------------------------------------
set nowyear = 2008
while ( $sflight <= $eflight )
set nowmonth = $month[$sflight]
set nowdate = $date[$sflight]
set mname = $monthchar[$month[$sflight]]
set mname2 = $monthchar2[$month[$sflight]]
#-------------------------------------------------------------------------------
set aflight = $sflight
if ( $sflight < 10 ) then
 set aflight = "0"$sflight
endif
echo "aflight=" $aflight $sflight $eflight
#-------------------------------------------------------------------------------
#set nowmonth = $flightmonth
#set nowdate = $flightdate
set monindex = 1
set julian = 0
#-------------------------------------------------------------------------------
while ( $monindex < $nowmonth )
 @ julian = $julian + $monthday[$monindex]
 @ monindex = $monindex + 1
end
@ julian = $julian + $nowdate    # calculate julian day
@ mjday = $julian - 1  # for meteo data

@ dateplus1 = $nowdate + 1
@ monthplus1 = $nowmonth
if ( $dateplus1 > $monthday[$monthplus1] ) then
 set dateplus1 = 1
 @ monthplus1 = $monthplus1 + 1
endif
if( $dateplus1 < 10 ) then
 set dateplus1 = "0"$dateplus1
endif
if( $monthplus1 < 10 ) then
 set monthplus1 = "0"$monthplus1
endif
echo $nowmonth $nowdate $monthplus1 $dateplus1

set newmonth = $nowmonth
if( $newmonth < 10) then
set newmonth = "0"$newmonth
endif

set newdate = $nowdate
if( $newdate < 10) then
set newdate = "0"$newdate
endif

#@ num2dncfiles = ($#ncdirlist * 2) + 1
#@ num3dncfiles = ($#ncdirlist * 2) + 1
@ num2dncfiles = 1
@ num3dncfiles = 1

#-------------------------------------------------------------------------------
if ( -e ./dc8-R13-1m-$newmonth$newdate-$aflight.csv ) then    # check if file exist
#-------------------------------------------------------------------------------
	set tmp = `wc  -l < ./dc8-R13-1m-$newmonth$newdate-$aflight.csv` 
	@ numts = $tmp - 1

cat > tmp.convert <<EOF
&control
 missions= $aflight
 prefix = './dc8-R13-1m-$newmonth$newdate-','tracer-htapv2-conc-dc8-1min-R13-$newmonth$newdate-'  ; file prefixes
 julianday= $julian
 num2dncfiles = 1
 num3dncfiles = 2
 numts = $numts
 suffix = '.csv','-merge-3d-species.csv'    ; file suffixes
/

&obs_index
 l_julian = 2  ; check all indexes from obs data file before run the program
 l_gmt    = 1
 l_lon    = 7
 l_lat    = 6
 l_alt    = 16
 l_press  = 9
 l_temp   = 10
 l_rh     = 36
 l_so4    = 65
 l_no     = 45
 l_no2    = 47
 l_bc     = 151
 l_so2    = 67
 l_amsso4 = 135
/
EOF
#-------------------------------------------------------------------------------
../namecut.x tmp.convert conv3d_tracer.ini
rm tmp.convert
#-------------------------------------------------------------------------------
setenv TOPO  ./TOPO-249x249.nc
setenv METEO3D ./TestMet3d.nc

setenv INFILE2D001 ./TestMet2d.nc
setenv INFILE3D001 ./TestMet3d.nc
setenv INFILE3D002 ./TestInput.nc

#-------------------------------------------------------------------------------
./tracer-arctas-249x249-1flight-R13-dc8-altcorrect-3d-species-curtain.x >& tracer-htapv2-249x249-1flight-R13-dc8-altcorrect-3d-species-curtain-$newmonth$newdate-$aflight.print.out
#-------------------------------------------------------------------------------
endif
#-------------------------------------------------------------------------------
@ sflight = $sflight + 1
end
#-------------------------------------------------------------------------------
#echo "end"
